/**
 * 
 * @author S.Gougeon
 * date : 18 sept. 2003
 * Centre de Ressousrces Informatiques
 * Universit de Rennes 1
 *
 */

package org.esup.apoweb;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import com.sopragroup.fwk.util.pool.*;


public class Etudiant {

	String numero = null;
	String dateNaiss = null;
	Connection conn = null;


	/**
	 * Constructeur
	 * @throws Exception
	 */
	
	public Etudiant(String user) throws Exception {
		try {
			// Interrogation LDAP
			Hashtable env = new Hashtable();
			env.put(Context.INITIAL_CONTEXT_FACTORY,"com.sun.jndi.ldap.LdapCtxFactory");
			env.put(Context.PROVIDER_URL, Config.getInstance().getUrlLDAP());
			DirContext ctx = new InitialDirContext(env);
			String[] param = {Config.getInstance().getAttributVouluLDAP()};
			SearchControls ctls = new SearchControls();
			ctls.setReturningAttributes(param);
			String filter = Config.getInstance().getAttributDeRechercheLDAP()+"="+user;	
			NamingEnumeration answer = ctx.search (Config.getInstance().getContextDeRechercheLDAP(), filter, ctls);
			SearchResult rs = (SearchResult) answer.next();		
			String resultat = (String) rs.getAttributes().get(param[0]).get(0);
			
			//Interrogation SQL de la base Apogee
			conn = PoolManager.getInstance().getConnection();
			String Query = Config.getInstance().getRequeteSQL();
			PreparedStatement pstmt = conn.prepareStatement(Query);
			pstmt.setString(1,resultat);
			ResultSet res = pstmt.executeQuery();
			res.next();
			numero = res.getString(1);
			dateNaiss = res.getString(2);
		}
		catch (Exception e) {
			throw new Exception("Erreur LDAP ou SQL : "+e);
		}
	}
	
	/**
	 * Accesseur
	 * @return
	 */
	public String getDateNaiss() {
		return dateNaiss;
	}

	/**
	 * Accesseur
	 * @return
	 */
	public String getNumero() {
		return numero;
	}

}