package org.esup.apoweb;

/**
 * @author S.Gougeon
 * date : 18 sept. 2003
 * Centre de Ressousrces Informatiques
 * Universit de Rennes 1
 * 
 * 
 */

import java.io.IOException;
import java.net.URL;
import javax.servlet.jsp.JspException;
import org.apache.commons.digester.*;
import org.xml.sax.SAXException;

public class Config
{     
	private static Config singleton = null;
	private String urlLDAP = null;
	private String userLDAP = null;
	private String pwdLDAP = null;
	private String contextDeRechercheLDAP = null;
	private String attributDeRechercheLDAP = null;
	private String attributVouluLDAP = null;
	private String requeteSQL = null;



	
	/**
	 * Constructeur
	 * @throws IOException
	 * @throws JspException
	 */
	public Config() throws IOException, JspException {
		try {
			Class requestingClass = this.getClass();
			URL resourceURL = requestingClass.getResource("/config/configLogin.xml");
			if (resourceURL == null){
				throw new JspException ("configLogin.xml does not exist ");
			}
			String path = resourceURL.getFile();
			//Cration d'une instance Digester 
			Digester dig = new Digester();
			//On rend l'objet disponible  la manipulation en le mettant en haut de la pile
			dig.push(this);
			//Chaque fois que "ROOT" sera lu  la lecture du fichier de config on fera appelle  la mthode addRoot() avec 4 paramtres
			dig.addCallMethod("ROOT","addRoot",7);
			//Premier paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-url",0);
			//Deuxime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-user",1);
			//Troisime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-pwd",2);
			//Quatrime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-contextDeRecherche",3);
			//Cinquime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-attributDeRecherche",4);
			//Sixime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/LDAP/LDAP-attributVoulu",5);
			//Septime paramtre de la mthode addRoot()
			dig.addCallParam("ROOT/SQL/SQL-requeteSQL",6);
			//On parse le fichier dont le chemin est pass en paramtre
			dig.parse(path);
		}
		catch (IOException e) {
				 throw new JspException("Impossible to load file configLogin.xml : "+e);
		} catch (SAXException e) {
			throw new JspException("Erreur de parsage de fichier : "+e);
		} 
	}
	
	/**
	 * Permet d'affecter les variables de la classe avec celles du fichier de configuration configLDAP.xml
	 * @param host
	 * @param port
	 * @param user
	 * @param pwd
	 * @param baseDn
	 * @param filtre
	 * @param attributRecherche
	 * @param elementVoulu
	 */
	
	public void addRoot(String url, String user, String pwd, String contextDeRecherche, String attributDeRecherche, String attributVoulu, String requete){
		urlLDAP = url;
		userLDAP = user;
		pwdLDAP = pwd;
		contextDeRechercheLDAP = contextDeRecherche;
		attributDeRechercheLDAP = attributDeRecherche;
		attributVouluLDAP = attributVoulu;
		requeteSQL = requete;
	}
	/**
	 * Accesseur
	 * @return Config Instance
	 * @throws IOException
	 * @throws JspException
	 */
	public static Config getInstance() throws IOException, JspException {
		if(singleton == null) {
			singleton = new Config();
		}
		return singleton;
	}

	/**
	 * Accesseur
	 * @return
	 */
	public String getAttributDeRechercheLDAP() {
		return attributDeRechercheLDAP;
	}


	/**
	 * Accesseur
	 * @return
	 */
	public String getAttributVouluLDAP() {
		return attributVouluLDAP;
	}


	/**
	 * Accesseur
	 * @return
	 */
	public String getUrlLDAP() {
		return urlLDAP;
	}

	/**
	 * Accesseur
	 * @return
	 */
	public String getPwdLDAP() {
		return pwdLDAP;
	}

	/**
	 * Accesseur
	 * @return
	 */
	public String getUserLDAP() {
		return userLDAP;
	}

	/**
	 * Accesseur
	 * @return
	 */
	public String getContextDeRechercheLDAP() {
		return contextDeRechercheLDAP;
	}

	/**
	 * Accesseur
	 * @return
	 */
	public String getRequeteSQL() {
		return requeteSQL;
	}

}